﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

using quicksdk;

public class EventHandle : QuickSDKListener {

	public GameObject messageBox;
	public GameObject mExitDialogCanvas;
	void showLog(string title, string message)
	{
		Debug.Log ("title: " + title + ", message: " + message);
	}
	// Use this for initialization
	void Start () {
		Debug.Log ("lyy  start " );

		QuickSDK.getInstance ().setListener (this);
		QuickSDK.getInstance ().init ();
	
		mExitDialogCanvas = GameObject.Find ("ExitDialog");
		if (mExitDialogCanvas != null) {
			mExitDialogCanvas.SetActive (false);
		}

	}
	// Update is called once per frame
	void Update () {
		 
	}

	public void onLogin()
	{
		QuickSDK.getInstance ().login ();
	}

	public void onLogout()
	{
		QuickSDK.getInstance ().logout ();

	}

	public void onShare()
	{
		QuickSDK.getInstance ().fbShareUrl ("https://www.baidu.com/");

	}
	public void onUserCenter()
	{
		QuickSDK.getInstance ().userCenter ();

	}


	public void onPay()
	{
		OrderInfo orderInfo = new OrderInfo();
		GameRoleInfo gameRoleInfo = new GameRoleInfo();		
		orderInfo.goodsID = "1001";
		orderInfo.goodsDesc = "10个钻石";
		orderInfo.extrasParams = "extparma";
		orderInfo.amount = 0.99;
		orderInfo.currency = "USD";	
		orderInfo.cpOrderID = "987654321";

		gameRoleInfo.gameRoleID = "000001";
		gameRoleInfo.gameRoleLevel = "1";
		gameRoleInfo.gameRoleName = "钱多多";	
		gameRoleInfo.serverName = "火星服务器";
		gameRoleInfo.vipLevel = "1";
		QuickSDK.getInstance ().pay (orderInfo, gameRoleInfo);
	}



	
	public void onUpdateRoleInfo()
	{
		//注：GameRoleInfo的字段，如果游戏有的参数必须传，没有则不用传
		GameRoleInfo gameRoleInfo = new GameRoleInfo();
		gameRoleInfo.gameRoleID = "000001";
		gameRoleInfo.gameRoleLevel = "1";
		gameRoleInfo.gameRoleName = "钱多多";	
		gameRoleInfo.serverName = "火星服务器";
		gameRoleInfo.vipLevel = "1";
		gameRoleInfo.serverId = "1";
	
		
		QuickSDK.getInstance ().updateRole(gameRoleInfo);
	}

	public void onNext(){
		Application.LoadLevel ("scene3");
	}

	public void onFinal(){
		Application.LoadLevel ("scene4");
	}


	public void onOk()
	{
		messageBox.SetActive (false);
	}

	public void onPauseGame()
	{
		Time.timeScale = 0;
	}

	public void onResumeGame()
	{
		Time.timeScale = 1;
	}
		
	//************************************************************以下是需要实现的回调接口*************************************************************************************************************************
	//callback
	public override void onInitSuccess()
	{
		showLog("onInitSuccess", "");
		//QuickSDK.getInstance ().login (); //如果游戏需要启动时登录，需要在初始化成功之后调用
	}

	public override void onInitFailed(ErrorMsg errMsg)
	{
		showLog("onInitFailed", "msg: " + errMsg.errMsg);
	}

	public override void onLoginSuccess(UserInfo userInfo)
	{
		showLog ("onLoginSuccess", "uid: " + userInfo.uid + " ,username: " + userInfo.userName + " ,userToken: " + userInfo.token + ", openType: " + userInfo.openType+ ", isGuest: " + userInfo.isGuest+ ", msg: " + userInfo.errMsg);
		Application.LoadLevel ("scene2");

	}

	public override void onLoginFailed (ErrorMsg errMsg)
	{
		showLog("onLoginFailed", "msg: "+ errMsg.errMsg);
	}

	public override void onLogoutSuccess ()
	{
		showLog("onLogoutSuccess", "");
		//注销成功后回到登陆界面
		Application.LoadLevel("scene1");
	}

	public override void onSubsSkuCallback(string skuId, string qkOrderId)
	{
		showLog("onSubsSkuCallback", "orderId: "+qkOrderId+",skuId: "+skuId);
	}

	public override void onPaySuccess (PayResult payResult)
	{
		showLog("onPaySuccess", "orderId: "+payResult.orderId+",extraParam"+payResult.extraParam);
	}

	public override void onPayCancel (PayResult payResult)
	{
		showLog("onPayCancel", "orderId: "+payResult.orderId+",extraParam"+payResult.extraParam);
	}

	public override void onPayFailed (PayResult payResult)
	{
		showLog("onPayFailed", "orderId: "+payResult.orderId+",extraParam"+payResult.extraParam);
	}




		
}

